/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.gui.StatusDisplayPanel;
import com.quantumdata.sct.gui.activityarea.ActivityArea;
import com.quantumdata.sct.gui.activityarea.ToolsActivityArea;
import com.quantumdata.sct.gui.actorbar.ClassifiedActorBar;
import com.quantumdata.sct.gui.actorbar.NamedActorBar;
import com.quantumdata.sct.gui.actorbar.SecondaryActorBar;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.wizard.IBODialog;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class ComplianceTesterToolUI
extends JFrame {
    private NamedActorBar m_namedActorBar;
    private ClassifiedActorBar m_classifiedActorBar;
    private SecondaryActorBar m_secondaryActorBar;
    private ActivityArea m_activityArea;
    private StatusDisplayPanel m_statusDisplayPanel;
    private SCTPanel m_secondaryActorBarPanel;
    private SCTPanel m_activityAreaPanel;

    public ComplianceTesterToolUI() {
        super("Test Management Environment Version " + SCTConstants.getReleaseVersion());
        this.init();
        this.setResizable(true);
        this.setSize(800, 600);
        this.setVisible(true);
        SCTConstants.screenCenterPlacement(this);
        this.setDefaultCloseOperation(3);
    }

    private void init() {
        this.m_statusDisplayPanel = new StatusDisplayPanel();
        this.m_namedActorBar = new NamedActorBar(this);
        JLabel jLabel = new JLabel(new ImageIcon("images/logo_header.gif"));
        this.m_namedActorBar.add(jLabel);
        this.m_namedActorBar.initializeGUI();
        this.m_namedActorBar.addAutoStep();
        SCTSelection.instance().setIBODialog(new IBODialog(this));
        SCTPanel sCTPanel = this.initTopPanel();
        sCTPanel.setBackground(Color.white);
        SCTPanel sCTPanel2 = this.initBottomPanel();
        sCTPanel2.setBackground(SCTConstants.qdiDkGray);
        this.initEastPanel();
        this.initCenterPanel();
        this.setSecondaryActorBar(this.m_classifiedActorBar.getSecondaryActorBar());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)sCTPanel, "North");
        container.add((Component)sCTPanel2, "South");
        container.add((Component)this.m_activityAreaPanel, "Center");
    }

    public void setSecondaryActorBar(int n) {
        SecondaryActorBar secondaryActorBar = this.m_classifiedActorBar.getSecondaryActorBar(n);
        this.setSecondaryActorBar(secondaryActorBar);
    }

    public void setTopPanelSelected(int n) {
        this.m_namedActorBar.setSelectedButton(n);
    }

    public void shiftTopPanelSelected(int n) {
        this.m_namedActorBar.setSelectedButton(this.m_namedActorBar.getLastSelectedIndex() + n);
    }

    public void setBottomPanelSelected(int n) {
        this.m_classifiedActorBar.setSelectedButton(n);
    }

    public void shiftBottomPanelSelected(int n) {
        this.m_classifiedActorBar.setSelectedButton(this.m_classifiedActorBar.getLastSelectedIndex() + n);
    }

    private SCTPanel initTopPanel() {
        SCTPanel sCTPanel = new SCTPanel();
        sCTPanel.setPreferredSize(new Dimension(800, 68));
        sCTPanel.setLayout(new GridBagLayout());
        this.m_namedActorBar.setPreferredSize(new Dimension(800, 49));
        this.m_namedActorBar.setMinimumSize(new Dimension(800, 49));
        this.m_statusDisplayPanel.setMinimumSize(new Dimension(800, 20));
        this.m_statusDisplayPanel.setMaximumSize(new Dimension(800, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        sCTPanel.add((Component)this.m_namedActorBar, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        sCTPanel.add((Component)this.m_statusDisplayPanel, gridBagConstraints);
        return sCTPanel;
    }

    private SCTPanel initBottomPanel() {
        this.m_classifiedActorBar = new ClassifiedActorBar(this, 3);
        this.m_classifiedActorBar.initializeGUI();
        this.m_classifiedActorBar.setSelectedButton(0);
        return this.m_classifiedActorBar;
    }

    private void initCenterPanel() {
        CardLayout cardLayout = new CardLayout();
        cardLayout.setHgap(12);
        cardLayout.setVgap(12);
        this.m_activityAreaPanel = new SCTPanel(cardLayout);
        this.m_activityAreaPanel.setColor1(Color.white);
        this.m_activityAreaPanel.setColor2(SCTConstants.qdiDkGray);
    }

    private void initEastPanel() {
        this.m_secondaryActorBarPanel = new SCTPanel(new CardLayout());
    }

    public void setSecondaryActorBar(SecondaryActorBar secondaryActorBar) {
        if (secondaryActorBar != null) {
            CardLayout cardLayout = (CardLayout)this.m_secondaryActorBarPanel.getLayout();
            this.m_secondaryActorBarPanel.add((Component)secondaryActorBar, secondaryActorBar.getName());
            cardLayout.show(this.m_secondaryActorBarPanel, secondaryActorBar.getName());
            this.m_secondaryActorBar = secondaryActorBar;
            ActivityArea activityArea = this.m_secondaryActorBar.getActivityArea();
            if (activityArea instanceof ToolsActivityArea) {
                if (SCTSelection.instance().getCurrentConnection() == null) {
                    MessageOptionPane.ShowMessage(this, "You must connect to the 882 before beginning to test (Press \"Host\").", "No connection to 882");
                    return;
                }
                if (SCTSelection.instance() == null || SCTSelection.instance().getUnitID() == null) {
                    MessageOptionPane.ShowMessage(this, "You must select a model and unit before beginning to test.", "No unit selected");
                    return;
                }
            }
            this.setActivityArea(activityArea);
        }
    }

    public void setActivityArea(ActivityArea activityArea) {
        if (activityArea != null) {
            CardLayout cardLayout = (CardLayout)this.m_activityAreaPanel.getLayout();
            this.m_activityAreaPanel.add((Component)activityArea, activityArea.getName());
            activityArea.preSelect();
            cardLayout.show(this.m_activityAreaPanel, activityArea.getName());
            this.m_activityArea = activityArea;
        }
    }

    public void setStatusPanelAttribute(int n, String string) {
        this.m_statusDisplayPanel.setAttribute(n, string);
    }

    public static void main(String[] stringArray) throws Exception {
        System.setProperty(XMLDAOFactory.dataFileEnv, "." + System.getProperty("file.separator") + "Properties.props");
        try {
            UIManager.setLookAndFeel("com.quantumdata.laf.QDILookAndFeel");
        }
        catch (Exception exception) {
            System.out.println("Failed to load QDI LAF");
        }
        new ComplianceTesterToolUI();
    }
}

